<!-- <?php echo basename( __FILE__ ); ?> -->
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	<div <?php post_class('clearfix') ?> id="post-<?php the_ID(); ?>">
		<h3 class="blogtitle"><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h3>
		<div class="entry clearfix">
			<?php the_content(); ?>
			<div class="archives clearfix">
			<h4><?php _e('All internal pages:', 'allure'); ?></h4>
			<ul><?php wp_list_pages('title_li='); ?></ul>

			<h4><?php _e('Monthly archive pages:', 'allure'); ?></h4>
			<ul><?php wp_get_archives('type=monthly'); ?></ul>

			<h4><?php _e('Topical archive pages:', 'allure'); ?></h4>
			<ul><?php wp_list_categories('title_li=0'); ?></ul>

			<h4><?php _e('Available RSS Feeds:', 'allure'); ?></h4>
			<ul>
			<li><a href="<?php bloginfo('rdf_url'); ?>" title="RDF/RSS 1.0 feed"><acronym title="Resource Description Framework">RDF</acronym>/<acronym title="Really Simple Syndication">RSS</acronym> 1.0 feed</a></li>
			<li><a href="<?php bloginfo('rss_url'); ?>" title="RSS 0.92 feed"><acronym title="Really Simple Syndication">RSS</acronym> 0.92 feed</a></li>
			<li><a href="<?php bloginfo('rss2_url'); ?>" title="RSS 2.0 feed"><acronym title="Really Simple Syndication">RSS</acronym> 2.0 feed</a></li>
			<li><a href="<?php bloginfo('atom_url'); ?>" title="Atom feed">Atom feed</a></li>
			</ul>
			</div>

			<div class="archives clearfix">
			<h4><?php _e('Last 50 blog posts:', 'allure'); ?></h4>
			<ul>
			<?php $archive_query = new WP_Query('showposts=50'); while ($archive_query->have_posts()) : $archive_query->the_post(); ?>
			<li><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></li>
			<?php endwhile; ?>
			</ul>
			</div>
		</div>
	</div>
	<?php endwhile; else: ?>
	<p><?php _e('Sorry, no posts matched your criteria.', 'allure'); ?></p>
	<?php endif; ?>