<?php

// Theme Prefix
define("THEME_PREFIX", "lsw_");


if ( ! isset( $content_width ) )
	$content_width = 638;

// THUMBNAILS
add_theme_support( 'post-thumbnails' );
add_image_size( 'home-featured', 600, 300, true); // Image Format
add_image_size( 'home-thumb', 175, 175, true); // Image Format



// AUTOMATIC FEED LINKS
add_theme_support('automatic-feed-links');


// CUSTOM MENUS
register_nav_menu('main_menu', __('Main Menu'));


// TRIM EXCERPT

//length
function new_excerpt_length($length) {
	return 55;
}
add_filter('excerpt_length', 'new_excerpt_length');

//read more
function new_excerpt_more($more) {
       global $post;
	return ' ...</p> <p class="read-more"><a href="'. get_permalink($post->ID) . '">' . 'Read the Rest &raquo;' . '</a></p>';
}
add_filter('excerpt_more', 'new_excerpt_more');



// CUSTOM TAGS FILTER
function lsw_tag_cloud($tags)
{
$tags = preg_replace_callback("|(class='tag-link-[0-9]+)('.*?)(style='font-size: )([0-9]+)(pt;')|",
create_function(
'$match',
'$low=1; $high=5; $sz=($match[4]-8.0)/(22-8)*($high-$low)+$low; return "{$match[1]} tagsize-{$sz}{$match[2]}";'
),
$tags);
return $tags;
}

add_action('wp_tag_cloud', 'lsw_tag_cloud');

// TEXT WIDGET SHORTCODES
// Now the text widget supports shortcodes
add_filter( 'widget_text', 'do_shortcode' );

// SIDEBAR WIDGETS

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name' => 'Sidebar',
'id' => 'sidebar-widget',
));

if ( function_exists('register_sidebar') )
register_sidebar(array(
'name' => 'Footer',
'id' => 'footer-widget',
));

function is_sidebar_active( $index = 1 ) {
	global $wp_registered_sidebars;

	if ( is_int( $index ) ) :
		$index = "sidebar-$index";
	else :
		$index = sanitize_title( $index );
		foreach ( (array) $wp_registered_sidebars as $key => $value ) :
			if ( sanitize_title( $value['name'] ) == $index ) :
				$index = $key;
				break;
			endif;
		endforeach;
	endif;

	$sidebars_widgets = wp_get_sidebars_widgets();

	if ( empty( $wp_registered_sidebars[$index] ) || !array_key_exists( $index, $sidebars_widgets ) || !is_array( $sidebars_widgets[$index] ) || empty( $sidebars_widgets[$index] ) )
		return false;
	else
		return true;
}



// DEFAULT NAVIGATION MENU
function lsw_default_nav() {

?>
	<ul class="menu">
		<li><a href="<?php echo home_url(); ?>/" title="Home" ><?php _e('Home', 'allure'); ?></a></li>
		<?php wp_list_pages('title_li='); ?>
	</ul>
<?php

}

// Custom Pagination Function
  function lsw_pagenavi($before = '', $after = '', $prelabel = '', $nxtlabel = '', $pages_to_show = 5, $always_show = false)
  {
      global $request, $posts_per_page, $wpdb, $paged, $wp_query;
      if ( empty( $max_page ) )
          $max_page = $wp_query->max_num_pages;
      if ( !$paged )
          $paged = 1;
      if (empty($prelabel)) {
          $prelabel = '';
      }
      if (empty($nxtlabel)) {
          $nxtlabel = '';
      }
      $half_pages_to_show = round($pages_to_show / 2);
      if (!is_single()) {
          if ($max_page > 1 || $always_show) {
              echo "$before <div class='pagination'>";
              if(!empty($prelabel))
                  previous_posts_link($prelabel);
              for ($i = $paged - $half_pages_to_show; $i <= $paged + $half_pages_to_show; $i++) {
                  if ($i >= 1 && $i <= $max_page) {
                      if ($i == $paged) {
                          echo "<span>$i</span>";
                      } else {
                          echo ' <a href="' . get_pagenum_link($i) . '">' . $i . '</a> ';
                      }
                  }
              }
              if(!empty($nxtlabel))
                  next_posts_link($nxtlabel, $max_page);
              if (($paged + $half_pages_to_show) < ($max_page)) {
                  echo '';
              }
              echo "</div> $after";
          }
      }
  }

// CUSTOM BACKGROUND
add_custom_background();


?>