<?php $meta_box = get_post_custom($post->ID); $video = $meta_box['custom_meta_video'][0]; ?>

<div <?php post_class(); ?>>
	
	<div class="post_column">
		<div class="post_icon">
			<img src="<?php bloginfo('template_url'); ?>/images/icon_post.png" title="Blog Post" alt="Blog Post" />
		</div>
		<div class="social_links">
			<div class="plus_btn">
				<g:plusone size="tall"></g:plusone>
			</div>
		    <div class="like_btn">
		        <fb:like href="<?php echo urlencode(get_permalink($post->ID)); ?>" layout="box_count" show_faces="false" width="50" font=""></fb:like>
		    </div>
		    <div class="tweet_btn">
		        <a href="http://twitter.com/share" class="twitter-share-button"
		        data-url="<?php the_permalink(); ?>"
		        data-text="<?php the_title(); ?>"
		        data-related=""
		        data-count="vertical">Tweet</a>
		    </div>
		</div>
	</div>
	
	<div class="post_content">
		<div class="comment_icon"><a href="<?php the_permalink(); ?>#respond"><?php comments_number('0', '1', '%'); ?></a></div>
		<div class="postdate"><p><?php the_time('m.j.y'); ?> &nbsp; <img src="<?php bloginfo('template_url'); ?>/images/icon_author.png" title="Author" alt="Author" /> <?php the_author_posts_link(); ?></p></div>
        <h1><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h1>
        <?php if ( $video ) : ?>
        	<div class="video"><?php echo $video; ?></div>
        <?php else: ?>
            <a class="thumbnail" href="<?php the_permalink() ?>" rel="bookmark"><?php the_post_thumbnail( 'home-thumbnail' ); ?></a>
        <?php endif; ?>
        <div class="postarea"><?php the_content(__("Read More")); ?></div>
        <div class="postmeta">
        	<p><strong><?php _e("Category:", 'organicthemes'); ?></strong> <?php the_category(', ') ?> &middot; <strong><?php _e("Tags:", 'organicthemes'); ?></strong> <?php the_tags('') ?></p>
        </div>
    </div>
    
</div>